/**
 * Show the response
 */
function showResponse(message)
{
    $('msgbox-wrapper').innerHTML = '';
    for(var i = 0; i < message.length; i++) {
        var messageDiv = document.createElement('div');
        $('msgbox-wrapper').appendChild(messageDiv);
        messageDiv.innerHTML = message[i]['message'];
        messageDiv.className = message[i]['css'];
        messageDiv.id = 'msgbox_'+i;
        new Effect.Appear(messageDiv);
        hideResponseBox(messageDiv);
    }
}

/**
 * Hide response boxes - Fast Code
 */
function hideResponseBox(name, timehide)
{
    if (typeof(timehide) == 'undefined') {
        timehide = '3000';
    }

    setTimeout('hideResponseBoxCallback("' + name.id + '")', timehide);
}

/**
 * Hide response boxes - JS Action (callback)
 */
function hideResponseBoxCallback(name)
{
    new Effect.Fade(name);
}

/**
 * Show working notification.
 */
function showWorkingNotification(msg)
{
    if (!msg) {
        msg = loading_message;
    }
    $('working_notification').innerHTML = msg;
    $('working_notification').style.visibility = 'visible';
    loading_message = default_loading_message;
}

/**
 * Hide working notification
 */
function hideWorkingNotification()
{
    $('working_notification').style.visibility = 'hidden';
}
