<?php
/**
 * Class to manage Gregorian calendar
 *
 * @category   Jaws_Date
 * @package    Core
 * @author     Amir Mohammad Saied <amir@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class Jaws_Date_Gregorian extends Jaws_Date
{
    /**
     *
     * @param   int $year   Gregorian year
     * @param   int $month  Gregorian month
     * @param   int $day    Gregorian day
     * @access  public
     * @return  array   Converted time
     */
    function ToBaseDate($year, $month, $day = 1)
    {
        $day = empty($day)? 1 : $day;
        $dt = mktime(0, 0, 0, $month, $day, $year);
        return array('year'      => $year,
                     'month'     => $month,
                     'day'       => $day,
                     'monthDays' => date("t", $dt),
                     'yearDay'   => date("z", $dt)
                    );
    }

    /**
     * Format the input date.
     *
     * @param  string  $date   Date string
     * @param  string  $format Format to use
     * @return The original date with a new format
     */
    function Format($date, $format = null)
    {
        if (empty($date)) {
            return;
        }

        if (strpos($date, '-')) {
            $date = mktime(substr($date, 11, 2), substr($date, 14, 2),
                           substr($date, 17, 2), substr($date, 5, 2),
                           substr($date, 8, 2),  substr($date, 0, 4));
        } elseif (strlen($date) == 14) {
            $date = mktime(substr($date, 8, 2),  substr($date, 10, 2),
                           substr($date, 12, 2), substr($date, 4, 2),
                           substr($date, 6, 2),  substr($date, 0, 4));
        } 

        if (empty($format)) {
            $format = $GLOBALS['app']->Registry->Get('/config/date_format');
        }

        if ($format == 'since') {
            return $this->SinceFormat($date);
        } else {
            if (strpos($format, 'MN') >= 0) {
                $aux   = '';
                $month = $this->MonthString(date('m', $date));
                $len   = strlen($month);
                for ($i = 0; $i < $len; $i++) {
                    $aux .= '\\'.$month[$i];
                }
                $month = $aux;
                $format = str_replace('MN', $month, $format);
            }

            if (strpos($format, 'DN') >= 0) {
                $aux = '';
                $day = $this->DayString(date('w', $date));
                $len = strlen($day);
                for ($i = 0; $i < $len; $i++) {
                    $aux .= '\\'.$day[$i];
                }
                $day = $aux;
                $format = str_replace('DN', $day, $format);
            }

            if (strpos($format,'AGO') >= 0) {
                $aux = '';
                $ago = $this->SinceFormat($date);
                $len = strlen($ago);
                for ($i = 0; $i < $len; $i++) {
                    $aux .= '\\'.$ago[$i];
                }
                $format = str_replace('AGO', $aux, $format);
            }

            return date($format, $date);
        }
    }
}
?>
