<?php
/**
 * Manage Jaws Errors
 *
 * @category   Error
 * @package    Core
 * @author     Jonathan Hernandez  <ion@suavizado.com>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
define('JAWS_ERROR_INFO',    0);
define('JAWS_ERROR_WARNING', 1);
define('JAWS_ERROR_ERROR',   2);
define('JAWS_ERROR_FATAL',   3);

class Jaws_Error
{
    /**
     * Error message
     *
     * @access  protected
     * @var     string
     * @see     GetMessage()
     */
    var $_Message;

    /**
     * Error code
     *
     * @access  protected
     * @var     string
     * @see     GetCode()
     */
    var $_Code;

    /**
     * The severity of the error.
     *
     * @access  protected
     * @var     string
     * @see     GetLevel()
     */
    var $_Level;

    /**
     * Constructor
     *
     * @access  public  $message Error message
     * @param   string  $code    Error code
     * @param   int     $level   The severity level of the error.
     * @access public
     */
    function Jaws_Error($message, $code = 0, $level = JAWS_ERROR_ERROR)
    {
        $this->_Message = $message;
        $this->_Code = $code;
        $this->_Level = $level;

        if (isset($GLOBALS['log'])) {
            $GLOBALS['log']->Log(JAWS_LOG_ERR, '[' . $code . ']: ' . $message, '');
        }
    }

    /**
     * Returns the Error message
     *
     * @access  public
     * @return  string  Error message
     */
    function GetMessage()
    {
        return $this->_Message;
    }

    /**
     * Returns the Error code
     *
     * @access  public
     * @return  string  Error code
     */
    function GetCode()
    {
        return $this->_Code;
    }

    /**
     * Returns the error level.
     *
     * @access  public
     * @return  int     The severity level.
     */
    function GetLevel()
    {
        return $this->_Level;
    }

    /**
     * Validates if an input is a error or not
     *
     * @access  public
     * @param   mixed   $input  Input to validate(can be boolean, object, numeric, etc)
     * @return  boolean True if input is a Jaws_Error, false if not.
     */
    function IsError(&$input)
    {
        return(bool)(is_object($input) &&(strtolower(get_class($input)) == 'jaws_error'));
    }

    /**
     * Prints a Fatal Error
     *
     * @access  public
     * @param   string  $message Message to print
     * @param   string  $file    File that is calling the method
     * @param   string  $line    Line where the method is being called
     */
    function Fatal($message, $file, $line)
    {
        //FIXME: And what will happen when it's being called from a WS?
        if (isset($GLOBALS['log'])) {
            $GLOBALS['log']->Log(JAWS_LOG_ERR, "[Fatal Error]\n $message  : " . __FILE__ . ':' . __LINE__);
        }

        if (defined('DEBUG_ACTIVATED') && DEBUG_ACTIVATED) {
            echo '<b style="color: #f00;"> JAWS Fatal Error:</b><br /><b>Page: </b>' .
                $file . "<br /><b>Line: </b>" . $line . "<br />" . $message;
            if (isset($GLOBALS['log'])) {
                $GLOBALS['log']->LogStackToScreen();
            }
        } else {
            //Get content
            $content = file_get_contents(JAWS_PATH . 'gadgets/ControlPanel/templates/FatalError.html');
            $content = str_replace('{message}', $message, $content);
            echo $content;            
            exit;
        }

        exit;
    }
}