<?php
/**
 * Show the Jaws Page not found message
 *
 * @category   Application
 * @package    Core
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2006-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class Jaws_HTTPError
{
    function Get($code, $title = null, $message = null)
    {
        $xss = $GLOBALS['app']->loadClass('XSS', 'Jaws_XSS');
        switch ($code) {
            case 404:
                header($xss->filter($_SERVER['SERVER_PROTOCOL'])." 404 Not Found");
                $title = empty($title)? _t('GLOBAL_HTTP_ERROR_TITLE_404') : $title;
                if (empty($message)) {
                    if (isset($_SERVER['REQUEST_URI']) && !empty($_SERVER['REQUEST_URI'])) {
                        $uri = $_SERVER['REQUEST_URI'];
                    } elseif (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
                        $uri = $_SERVER['PHP_SELF'] . '?' .$_SERVER['QUERY_STRING'];
                    } else {
                        $uri = '';
                    }
                    $uri = $xss->filter(urldecode($uri));
                    $message = _t('GLOBAL_HTTP_ERROR_CONTENT_404', $uri);
                }
                break;

            case 403:
                header($xss->filter($_SERVER['SERVER_PROTOCOL'])." 403 Forbidden");
                $title   = empty($title)? _t('GLOBAL_HTTP_ERROR_TITLE_403') : $title;
                $message = empty($message)? _t('GLOBAL_HTTP_ERROR_CONTENT_403') : $message;
                break;

            case 503:
                header($xss->filter($_SERVER['SERVER_PROTOCOL'])." 503 Service Unavailable");
                $title   = empty($title)? _t('GLOBAL_HTTP_ERROR_TITLE_503') : $title;
                $message = empty($message)? _t('GLOBAL_HTTP_ERROR_CONTENT_503') : $message;
                break;

            default:
                $title   = empty($title)? _t("GLOBAL_HTTP_ERROR_TITLE_$code") : $title;
                $message = empty($message)? _t("GLOBAL_HTTP_ERROR_CONTENT_$code") : $message;
        }

        // if current theme has a error code html file, return it, if not return the messages.
        $theme = $GLOBALS['app']->Registry->Get('/config/theme');
        if (file_exists(JAWS_DATA. "themes/$theme/$code.html")) {
            $tpl = new Jaws_Template();
            $tpl->Load("$code.html");
            $tpl->SetBlock($code);
            $tpl->SetVariable('title', $title);
            $tpl->SetVariable('content', $message);
            $tpl->ParseBlock($code);
            return $tpl->Get();
        }

        return "<h1>$title</h1><p>$message</p>";
    }
}