<?php
/**
 * Class to clean a string, it removes all the accents of a string
 *
 * @category   JawsType
 * @package    Core
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class Jaws_StringClean
{
    /**
     * Cleans all the accents and converts all those 'funny' unicode
     * chars to readable ones.
     *
     * For example it will convert: ormar to Thormar.
     *
     * @access  public
     * @param   string  $str   String to clean
     * @return  string  Clean string
     */
    function clean($str)
    {
        $str = strtr($str, array(
                                 unichr(198) => 'AE',  //capital AE
                                 unichr(208) => 'DH',  //capital eth
                                 unichr(216) => 'OE',  //capital O with Stroke
                                 unichr(222) => 'Th', //capital thorn
                                 unichr(223) => 'ss',   //sharp s
                                 unichr(230) => 'ae',  //lower AE
                                 unichr(240) => 'dh',  //lower eth
                                 unichr(248) => 'oe',  //lower O with Stroke
                                 unichr(254) => 'th', //lower thorn
                                 unichr(255) => 'y',   //y umlaut
                                 unichr(253) => 'y',   //y acute
                                 unichr(231) => 'c',   //c cedilla
                                 unichr(199) => 'C',   //capital c cedilla
                                 unichr(181) => 'u',   //Micro sign
                                 unichr(241) => 'n',   //n tilde
                                 unichr(209) => 'n',   //capital n tilde
                                 unichr(248) => 'o',   //o slash
                                 )
                     );
        //Letter A
        $str = strtr($str, array(
                                 unichr(192) => 'A', unichr(193) => 'A', unichr(194) => 'A',
                                 unichr(195) => 'A', unichr(196) => 'A', unichr(197) => 'A'));
        //Letter E
        $str = strtr($str, array(
                                 unichr(200) => 'E', unichr(201) => 'E', unichr(202) => 'E',
                                 unichr(203) => 'E'));
        //Letter I
        $str = strtr($str, array(
                                 unichr(204) => 'I', unichr(205) => 'I', unichr(206) => 'I',
                                 unichr(207) => 'I'));
        //Letter O
        $str = strtr($str, array(
                                 unichr(210) => 'O', unichr(211) => 'O', unichr(212) => 'O',
                                 unichr(213) => 'O', unichr(214) => 'O', unichr(216) => 'O'));
        //Letter U
        $str = strtr($str, array(
                                 unichr(217) => 'U', unichr(218) => 'U', unichr(219) => 'U',
                                 unichr(220) => 'U'));
        //Letter a
        $str = strtr($str, array(
                                 unichr(224) => 'a', unichr(225) => 'a', unichr(226) => 'a',
                                 unichr(227) => 'a', unichr(228) => 'a', unichr(229) => 'a'));
        //Letter e
        $str = strtr($str, array(
                                 unichr(232) => 'e', unichr(233) => 'e', unichr(234) => 'e',
                                 unichr(235) => 'e'));
        //Letter i
        $str = strtr($str, array(
                                 unichr(236) => 'i', unichr(237) => 'i', unichr(238) => 'i',
                                 unichr(239) => 'i'));
        //Letter o
        $str = strtr($str, array(
                                 unichr(242) => 'o', unichr(243) => 'o', unichr(244) => 'o',
                                 unichr(245) => 'o', unichr(246) => 'o', unichr(248) => 'o'));
        //Letter u
        $str = strtr($str, array(
                                 unichr(249) => 'u', unichr(250) => 'u', unichr(251) => 'u',
                                 unichr(252) => 'u'));
        return $str;
    }
}
//Check if the function doesn't exist, some other projects are using it
if (!function_exists('unichr')) {
    /**
     * Returns the unicode char
     *
     * For more information check:
     * http://www.dkinweb.com/ascii-characters.php
     *
     * @param  int  $dec  Unicode number
     * @return string     The unicode char
     */
    function unichr($dec) {
        if ($dec < 128) {
            $utf = chr($dec);
        } else if ($dec < 2048) {
            $utf = chr(192 + (($dec - ($dec % 64)) / 64));
            $utf .= chr(128 + ($dec % 64));
        } else {
            $utf = chr(224 + (($dec - ($dec % 4096)) / 4096));
            $utf .= chr(128 + ((($dec % 4096) - ($dec % 64)) / 64));
            $utf .= chr(128 + ($dec % 64));
        }
        return $utf;
    }

}