<?php
/**
 * Jaws URL Mapping - SEO Driver
 *
 * @category   UrlMapping
 * @package    Core
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
class Jaws_URLMapping_SEO extends Jaws_URLMapping
{
    /**
     * Parses a QUERY URI and if its valid it extracts the values from
     * it and creates $_GET variables for each value.
     *
     * @param   string  $path   Query URI
     */
    function Parse($path)
    {
        $lastPos = strripos($path, '.htm');
        if ($lastPos != false) {
            $path = substr($path, 0, $lastPos);
        }

        if (parent::parse($path) === false) {
            $request =& Jaws_Request::getInstance();
            $matches = preg_split('/[\s\/]+/', $path);
            $c_matches = count($matches);
            if ($c_matches >= 2) { //at least we should have gadget and action
                $request->set('get', 'gadget', $matches[0]);
                $request->set('get', 'action', $matches[1]);
                for ($i = 2; $i < $c_matches; $i += 2) {
                    $request->set('get', $matches[$i], $matches[$i+1]);
                }
            }

            return true;
        }

        return false;
    }

    /**
     * Does the reverse stuff for an URL map. It gets all the params i
     * as an array and converts all the stuff to an URL map
     *
     * @access  public
     * @param   string  $gadget   Gadget's name
     * @param   string  $action   Gadget's action name
     * @param   array   $params   Params that the URL map requires
     * @return  string  The real URL map (aka jaws permalink)
     */
    function GetURLFor($gadget, $action, $params = null)
    {
        if ($this->_enabled && isset($this->_map[$gadget][$action])) {
            foreach ($this->_map[$gadget][$action] as $map) {
                $url = $map['map'];
                if (is_array($params)) {
                    foreach ($params as $paramName => $paramValue) {
                        $url = str_replace('{' . $paramName . '}', $paramValue, $url);
                    }
                }

                $current_script = $map['file'];
                if (!preg_match('#{\w+}#si', $url)) {
                    if ($this->_use_rewrite) {
                        // TODO: Test this...
                        return $url.'.html';
                    }

                    return '?' . $url.'.html';
                }
            }
            return $common_url;
        }

        $url = $gadget . '/' . $action;
        if (is_array($params)) {
            foreach ($params as $k => $v) {
                $url .= '/'. $k .'/'. $v;
            }
        }
        return $url.'.html';
    }
}