<?php
/**
 * Jaws TinyMCE Wrapper (uses JS and disable plugins)
 *
 * @category   Widget
 * @package    Core
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
require_once JAWS_PATH . 'libraries/piwi/Widget/Container/Container.php';
class Jaws_Widgets_TinyMCE extends Container
{
    /**
     * @access  public
     * @var     object
     */
    var $TextArea;

    /**
     * @access  private
     * @var     object
     */
    var $_Name;

    /**
     * @access  private
     * @var     object
     */
    var $_Class;

    /**
     * @access  private
     * @var     object
     * @see     function  GetValue
     */
    var $_Value;

    /**
     * @access  private
     * @var     object
     */
    var $_Container;

    /**
     * @access  private
     * @var     Label
     * @see     function  GetLabel
     * @see     function  SetLabel
     */
    var $_Label;

    /**
     * @access  private
     * @var     string
     */
    var $_Gadget;

    /**
     * for info see:
     * http://wiki.moxiecode.com/index.php/TinyMCE:Configuration/mode
     * @access  private
     */
    var $_Mode = 'textareas';

    /**
     * @access  private
     * @var     string
     */
    var $_Theme = 'advanced';

    /**
     * TinyMCE base actions
     *
     * @access  private
     */
    var $_BaseToolbar = array(
        'bold,italic,strikethrough,underline,|,justifyleft,justifycenter,justifyright,justifyfull,|,bullist,numlist,outdent,indent,|,fontselect,fontsizeselect,|,code',
        'ltr,rtl,|,cut,copy,paste,pastetext,pasteword,|,styleprops,attribs,|,forecolor,backcolor,|,hr,|,link,unlink,image,|,undo,redo,|,cleanup',
    );

    /**
     * TinyMCE ompatibile browsers
     *
     * @access  private
     */
    var $_Browsers = array('msie', 'gecko', 'opera', 'safari');

    /**
     * for info see:
     * http://wiki.moxiecode.com/index.php/TinyMCE:Configuration/extended_valid_elements
     *
     * @access  private
     */
    var $_ExtendedValidElements = '';

    /**
     * for info see:
     * http://wiki.moxiecode.com/index.php/TinyMCE:Configuration/invalid_elements
     *
     * @access  private
     */
    var $_InvalidElements = '';

    /**
     * Main Constructor
     *
     * @access  public
     */
    function Jaws_Widgets_TinyMCE($gadget, $name, $value = '', $label = '')
    {
        require_once JAWS_PATH . 'include/Jaws/StringHtml.php';
        //$value = Jaws_StringHtml::AutoParagraph($value);
        $value = str_replace('&lt;', '&amp;lt;', $value);
        $value = str_replace('&gt;', '&amp;gt;', $value);

        $this->_Name  = $name;
        $this->_Value = $value;

        $this->TextArea =& Piwi::CreateWidget('TextArea', $name, $this->_Value, '', '14');
        $this->setClass($name);
        $this->_Label =& Piwi::CreateWidget('Label', $label, $this->TextArea);

        // Add container
        $this->_Container =& Piwi::CreateWidget('VBox');
        $this->_Container->PackStart($this->_Label);
        $this->_Container->PackStart($this->TextArea);

        $this->_Gadget = $gadget;
        parent::init();
    }

    function buildXHTML()
    {
        static $alreadyLoaded;
        $alreadyLoaded = isset($alreadyLoaded)? true : false;

        $tinymcePlugins = array();
        $lang = $GLOBALS['app']->GetLanguage();
        $pluginDir = JAWS_PATH . 'libraries/tinymce/plugins/';
        if (is_dir($pluginDir)) {
            $dirs = scandir($pluginDir);
            foreach($dirs as $dir) {
                if ($dir != '.' && $dir != '..' && is_dir($pluginDir.$dir)) {
                    $tinymcePlugins[] = $dir;
                }
            }
        }

        $jawsPlugins = array();
        $jawsPluginsFunctions = '';
        // FIXME: we must found a way for load Jaws's plugins in tinyMCE
        /*
        $pluginTemplate = file_get_contents(JAWS_PATH . 'libraries/tinymce/plugin_template.js');
        $availablePlugins = explode(',', $GLOBALS['app']->Registry->Get('/plugins/parse_text/enabled_items'));
        foreach ($availablePlugins as $plugin) {
            $file   = JAWS_PATH . 'plugins/' . $plugin . '/' . $plugin . '.php';
            $use_in = '/plugins/parse_text/' . $plugin . '/use_in';
            $GLOBALS['app']->Registry->LoadFile($plugin, 'plugins');
            if (file_exists($file) &&
                (in_array($this->_Gadget, explode(',', $GLOBALS['app']->Registry->Get($use_in))) ||
                $GLOBALS['app']->Registry->Get($use_in) == '*'))
            {
                require_once $file;
                $plugintmp     = new $plugin();
                $plugincontrol = $plugintmp->GetWebControl("'".$this->TextArea->getID()."'");

                if (is_object($plugincontrol)) {
                    $plugincontrolValue = $plugincontrol->Get();
                    $plugincontrolValue = preg_replace('/\"(.*?)\"/si', '\"\\1\"', $plugincontrolValue);
                    $plugincontrolValue = str_replace("'", "\'", $plugincontrolValue);
                    $plugincontrolValue = str_replace("\\n", "\\\\n", $plugincontrolValue);
                    $plugincontrolValue = preg_replace("/(^[\r\n]*|[\r\n]+)+/", "", $plugincontrolValue);
                    if (preg_match_all('/\\s*<(td ?[^>]*)\\s*>(.*?)<\/td>/si', $plugincontrolValue, $matches) > 0) {
                        if (isset($matches[2]) && count($matches[2] > 0)) {
                            $plugincontrolValue = implode("&nbsp;", $matches[2]);
                        }
                    }
                    if (!empty($plugincontrolValue)) {
                        $pluginTemplateTmp = str_replace('{pluginName}', $plugin, $pluginTemplate);
                        $pluginTemplateTmp = str_replace('{pluginElement}', $plugincontrolValue, $pluginTemplateTmp);
                        $jawsPluginsFunctions .= $this->compactFile($pluginTemplateTmp)."\n\n";
                        $jawsPlugins[] = $plugin;
                    }
                }
            }
        }
        */

        $jawsPlugins  = implode($jawsPlugins, ',');
        $tinymcePlugins = implode($tinymcePlugins, ',');
        if (!empty($tinymcePlugins) && !empty($jawsPlugins)) {
            $plugins = $tinymcePlugins . ',' . $jawsPlugins;
        } else {
            $plugins = $tinymcePlugins . $jawsPlugins;
        }

        $toolbars   = $this->_BaseToolbar;
        $toolbars[] = $tinymcePlugins;
        $toolbars[] = $jawsPlugins;

        $this->_XHTML = $this->_Container->Get();

        if (!$alreadyLoaded) {
            $this->_XHTML.= '<script language="javascript" type="text/javascript" src="'.
                        $GLOBALS['app']->getSiteURL(false).'/libraries/tinymce/tiny_mce.js"></script>'."\n";
            $this->_XHTML.= '<script language="javascript" type="text/javascript" src="'.
                        $GLOBALS['app']->getSiteURL(false).'/libraries/tinymce/jawsMCEWrapper.js"></script>'."\n";
        }

        $this->_XHTML.= "<script type=\"text/javascript\">\n";
        $this->_XHTML.= $jawsPluginsFunctions;

        $fbrowser = $GLOBALS['app']->getSiteURL(). '/'. BASE_SCRIPT. '?gadget=FileBrowser&action=TinyMCE';
        $this->_XHTML.= "function jaws_filebrowser_callback(field_name, url, type, win) {\n";
        $this->_XHTML.= "var fbrowser = '$fbrowser&type=' + type;\n";
        $this->_XHTML.= "tinyMCE.activeEditor.windowManager.open({\n";
        $this->_XHTML.= "   file : fbrowser,\n";
        $this->_XHTML.= "   title : 'My File Browser',\n";
        $this->_XHTML.= "   width : 600,\n";
        $this->_XHTML.= "   height : 500,\n";
        $this->_XHTML.= "   resizable : 'yes',\n";
        $this->_XHTML.= "   scrollbars : 'yes',\n";
        $this->_XHTML.= "   inline : 'yes',\n";
        $this->_XHTML.= "   close_previous : 'no'\n";
        $this->_XHTML.= "}, {\n";
        $this->_XHTML.= "   window : win,\n";
        $this->_XHTML.= "   input : field_name\n";
        $this->_XHTML.= "});\n";
        $this->_XHTML.= "return false;\n";
        $this->_XHTML.= "}";

        $this->_XHTML.= "tinyMCE.init({\n";
        $this->_XHTML.= "mode : '{$this->_Mode}',\n";
        $this->_XHTML.= "language :'{$lang}',\n";
        $this->_XHTML.= "theme : '{$this->_Theme}',\n";
        $this->_XHTML.= "plugins : '{$plugins}',\n";
        
        foreach ($toolbars as $key => $toolbar) {
            $index = $key + 1;
            $this->_XHTML.= "theme_{$this->_Theme}_buttons{$index} : '$toolbar',\n";
        }
        $index = $index + 1;
        $this->_XHTML.= "theme_{$this->_Theme}_buttons{$index} : '',\n";

        $this->_XHTML.= "theme_{$this->_Theme}_toolbar_location : 'top',\n";
        $this->_XHTML.= "theme_{$this->_Theme}_toolbar_align : 'center',\n";
        $this->_XHTML.= "theme_{$this->_Theme}_path_location : 'bottom',\n";
        $this->_XHTML.= "theme_{$this->_Theme}_resizing : true,\n";
        $this->_XHTML.= "theme_{$this->_Theme}_resize_horizontal : false,\n";
        $this->_XHTML.= "browsers : '" . implode($this->_Browsers, ',') . "',\n";
        $this->_XHTML.= "directionality : '"._t('GLOBAL_LANG_DIRECTION')."',\n";
        $this->_XHTML.= "tab_focus : ':prev,:next',\n";
        $this->_XHTML.= "dialog_type : 'modal',\n";
        $this->_XHTML.= "entity_encoding : 'raw',\n";
        $this->_XHTML.= "relative_urls : true,\n";
        $this->_XHTML.= "remove_script_host : false,\n";
        $this->_XHTML.= "force_p_newlines : true,\n";
        $this->_XHTML.= "force_br_newlines : false,\n";
        $this->_XHTML.= "convert_newlines_to_brs : false,\n";
        $this->_XHTML.= "remove_linebreaks : true,\n";
        $this->_XHTML.= "nowrap : false,\n";
        $this->_XHTML.= "apply_source_formatting : true,\n";
        //$this->_XHTML.= "save_callback : 'jaws_save_callback',\n";
        //$this->_XHTML.= "cleanup_callback : 'myCustomCleanup',\n";
        //$this->_XHTML.= "file_browser_callback : 'jaws_filebrowser_callback',\n";
        $this->_XHTML.= "content_css : \"" . JAWS_DPATH . "gadgets/ControlPanel/resources/tinyMCE.css\",\n";
        $this->_XHTML.= "extended_valid_elements : '" . $this->_ExtendedValidElements . "',\n";
        $this->_XHTML.= "invalid_elements : '" . $this->_InvalidElements . "',\n";
        $this->_XHTML.= "editor_selector : '{$this->_Class}'\n";
        $this->_XHTML.= "});\n";
        $this->_XHTML.= "</script>\n";
    }

    /**
     * Sets the ID for the widget int he first call and in next calls it places the id
     * in the TextArea
     *
     * @access  public
     * @param   string   $id  Widget ID
     */
    function setID($id)
    {
        static $containerID;
        if (!isset($containerID)) {
            parent::setID($id);
            $containerID = $this->getID();
        } else {
            $this->TextArea->setID($id);
        }
    }

    /**
     * Set the className of the TextArea
     *
     * @access    public
     */
    function setClass($class)
    {
        $this->_Class = $class;
        $this->TextArea->setClass($class);
    }

    /**
     * Sets the label displayed with the textarea
     *
     * @access public
     * @param  string $label The label to display.
     * @return null
     */
    function SetLabel($label)
    {
        $this->_Label->SetValue($label);
    }

    /**
     * Set the width of the editor
     *
     * @access  public
     * @param   string  $width  Width
     */
    function SetWidth($width)
    {
        $currentStyle = $this->_Container->getStyle();
        if (empty($currentStyle)) {
            $currentStyle = 'width: '. $width.';';
        } else {
            if (strpos($currentStyle, 'width:') === false) {
                if (substr($currentStyle, -1) != ';') {
                    $currentStyle = $currentStyle . ';';
                }
                $currentStyle = $currentStyle . 'width: '. $width.';';
            }
        }
        $this->_Container->SetStyle($currentStyle);
    }

    /**
     * Set the TinyMCE theme
     *
     * @access    public
     */
    function setTheme($theme)
    {
        $this->_Theme = $theme;
    }

    function compactFile($content)
    {
        //FROM WP
        $content = preg_replace("!(^|\s+)//.*$!m", "", $content);
        $content = preg_replace("!/\*.*?\*/!s", "", $content);
        $content = preg_replace("!^\t+!m", "", $content);
        $content = str_replace("\r", "", $content);
        $content = preg_replace("!(^|{|}|;|:|\))\n!m", '\\1', $content);

        return $content;
    }
}
?>
