<?php
/**
 * Index page for jaws
 *
 * @category   Application
 * @package    Core
 * @author     Jonathan Hernandez <ion@suavizado.com>
 * @author     Pablo Fischer <pablo@pablo.com.mx>
 * @author     Helgi ormar <dufuz@php.net>
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2005-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/lesser.html
 */
define('JAWS_SCRIPT', 'index');
define('BASE_SCRIPT', basename(__FILE__));
define('PATH_SCRIPT', dirname(__FILE__));
define('APP_TYPE',    'web');

// Redirect to the installer if JawsConfig can't be found.
if (!file_exists(PATH_SCRIPT . '/config/JawsConfig.php')) {
    header('Location: install/index.php');
    exit;
} else {
    require PATH_SCRIPT . '/config/JawsConfig.php';
}

require_once JAWS_PATH . 'include/Jaws/InitApplication.php';
if (DEBUG_ACTIVATED) {
    // Log start time (microseconds)
    $mtime = microtime();
    $mtime = explode(' ', $mtime);
    $mtime = (double) $mtime[0] + $mtime[1];
    $tstart = $mtime;
}

//now developers can add ACL to gadget for check in frontend area
$GLOBALS['app']->loadClass('ACL', 'Jaws_ACL');

// Init layout...
$GLOBALS['app']->InstanceLayout();
$GLOBALS['app']->Layout->Load();

$GLOBALS['app']->Map->Parse();

$request =& Jaws_Request::getInstance();
$get_gadget = $request->get('gadget', 'get');

if ($get_gadget !== null) {
    $gadget = $get_gadget;
} else {
    $post_gadget = $request->get('gadget', 'post');
    $gadget = $post_gadget !== null ? $post_gadget : '';
}

$get_action = $request->get('action', 'get');
if ($get_action !== null) {
    $action = $get_action;
} else {
    $post_action = $request->get('action', 'post');
    $action = $post_action !== null ? $post_action : '';
}

// Check for requested gadget
if (!empty($gadget)) {
    // Convert first letter to ucase to backwards compability
    $ReqGadget = ucfirst($gadget);
    if (!Jaws_Gadget::IsValid($ReqGadget)) {
        Jaws_Error::Fatal("Invalid requested gadget", __FILE__, __LINE__);
    }

    $ReqAction = !empty($action) ? $action : 'DefaultAction';
    $am_i_index = false;
} else {
    $am_i_index = true;
    $ReqGadget = $GLOBALS['app']->Registry->Get('/config/main_gadget');
    if ($ReqGadget) {
        if (isset($_SERVER['QUERY_STRING']) && !empty($_SERVER['QUERY_STRING'])) {
            // We're requesting something weird... let's return a 404.
            $ReqAction = '_404';
        } else {
            $ReqAction = 'DefaultAction';
        }
    }
}

if (!empty($ReqGadget)) {
    $goGadget = $GLOBALS['app']->LoadGadget($ReqGadget);
    if (Jaws_Error::IsError($goGadget)) {
        Jaws_Error::Fatal("Error loading gadget: $ReqGadget", __FILE__, __LINE__);
    }

    $goGadget->SetAction($ReqAction);
    $action = $goGadget->GetAction();
    $standAloneMode = $goGadget->isStandAlone($action);
}
// If requested action is `stand alone' just print it
if (!empty($ReqGadget) && $standAloneMode) {
    echo $goGadget->Execute();
} else {
    // If requested action
    if (!empty($ReqGadget) && !$goGadget->IsNormal($action)) {
        Jaws_Error::Fatal("Invalid operation: You can't execute requested action. This action is part of admin or ".
                         "can only be used in the layout (not via the URL)", __FILE__, __LINE__);
    }
    $GLOBALS['app']->RunAutoload();
    $GLOBALS['app']->Layout->Populate($goGadget, $am_i_index);
    $GLOBALS['app']->Layout->Show();
}

// Sync session
$GLOBALS['app']->Session->Synchronize();

if (DEBUG_ACTIVATED) {
    $client = $request->get('client', 'get');
    if ($action != 'Ajax' && $client === null) {
        // Log generation time
        $mtime = microtime();
        $mtime = explode(' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $tend  = $mtime;
        $totaltime = ($tend - $tstart);
        $GLOBALS['log']->Log(JAWS_LOG_INFO, 'Page was generated in '. $totaltime . ' seconds');
        $GLOBALS['log']->Log(JAWS_LOG_INFO, '[Jaws End] ' . date('M/d/Y H:i:s') . ':' . __FILE__ . ':' .  __LINE__);
        if (function_exists('memory_get_usage')) {
            $GLOBALS['log']->Log(JAWS_LOG_INFO, 'Memory Usage: ' . round(memory_get_usage() / 1024) . ' KB');
        }
        $GLOBALS['log']->LogStackToScreen();
    }
}
