<?php
/**
 * Meta Data
 *
 * "Project-Id-Version: Install"
 * "Last-Translator: Ali Fazelzadeh <afz@php.net>"
 * "Language-Team: EN"
 * "MIME-Version: 1.0"
 * "Content-Type: text/plain; charset=UTF-8"
 * "Content-Transfer-Encoding: 8bit"
 */

/* Installer common words */
define('_EN_INSTALL_INTRODUCTION', "Introduction");
define('_EN_INSTALL_AUTHENTICATION', "Authentication");
define('_EN_INSTALL_REQUIREMENTS', "Requirements");
define('_EN_INSTALL_DATABASE', "Database");
define('_EN_INSTALL_CREATEUSER', "Create A User");
define('_EN_INSTALL_SETTINGS', "Settings");
define('_EN_INSTALL_WRITECONFIG', "Save Configuration");
define('_EN_INSTALL_FINISHED', "Finished");

/* Introduction */
define('_EN_INSTALL_INTRO_WELCOME', "Welcome to the Jaws installer.");
define('_EN_INSTALL_INTRO_INSTALLER', "Using the installer you will be guided through setting up your website, please make sure you have the following things available");
define('_EN_INSTALL_INTRO_DATABASE', "Database details - hostname, username, password, database name.");
define('_EN_INSTALL_INTRO_FTP', "A way of uploading files, probably FTP.");
define('_EN_INSTALL_INTRO_MAIL', "Your Mailserver informations (hostname, username, password) if you are using a mailserver.");
define('_EN_INSTALL_INTRO_LOG', "Log the process (and errors) of the installation to a file ({0})");
define('_EN_INSTALL_INTRO_LOG_ERROR', "Note: If you want to log the process (and errors) of the installation to a file you first need to set write-access permissions to the ({0}) directory and then refresh this page with your browser");

/* Authentication */
define('_EN_INSTALL_AUTH_PATH_INFO', "To make sure that you are really the owner of this site, please create a file called <strong>{0}</strong> in your Jaws installation directory (<strong>{1}</strong>).");
define('_EN_INSTALL_AUTH_UPLOAD', "You can upload the file in the same way you uploaded your Jaws install.");
define('_EN_INSTALL_AUTH_KEY_INFO', "The file should contain the code shown in the box below, and nothing else.");
define('_EN_INSTALL_AUTH_ENABLE_SECURITY', "Enable secure installation (Powered by RSA)");
define('_EN_INSTALL_AUTH_ERROR_RSA_KEY_GENERATION', "Error in RSA key generation. please try again.");
define('_EN_INSTALL_AUTH_ERROR_NO_MATH_EXTENSION', "Error in RSA key generation. No available any math extension.");
define('_EN_INSTALL_AUTH_ERROR_KEY_FILE', "Your key file ({0}) was not found, please make sure you created it, and the web server is able to read it.");
define('_EN_INSTALL_AUTH_ERROR_KEY_MATCH', "The key found ({0}), doesn't match the one below, please check that you entered the key correctly.");

/* Requirements */
define('_EN_INSTALL_REQ_REQUIREMENT', "Requirement");
define('_EN_INSTALL_REQ_OPTIONAL', "Optional but recommended");
define('_EN_INSTALL_REQ_RECOMMENDED', "Recommended");
define('_EN_INSTALL_REQ_DIRECTIVE', "Directive");
define('_EN_INSTALL_REQ_ACTUAL', "Actual");
define('_EN_INSTALL_REQ_RESULT', "Result");
define('_EN_INSTALL_REQ_PHP_VERSION', "PHP version");
define('_EN_INSTALL_REQ_GREATER_THAN', ">= {0}");
define('_EN_INSTALL_REQ_DIRECTORY', "{0} directory");
define('_EN_INSTALL_REQ_EXTENSION', "{0} extension");
define('_EN_INSTALL_REQ_FILE_UPLOAD', "File Uploads");
define('_EN_INSTALL_REQ_SAFE_MODE', "Safe mode");
define('_EN_INSTALL_REQ_READABLE', "Readable");
define('_EN_INSTALL_REQ_WRITABLE', "Writable");
define('_EN_INSTALL_REQ_OK', "OK");
define('_EN_INSTALL_REQ_BAD', "BAD");
define('_EN_INSTALL_REQ_OFF', "Off");
define('_EN_INSTALL_REQ_ON', "On");
define('_EN_INSTALL_REQ_RESPONSE_DIR_PERMISSION', "The directory {0} are either not readable or writable, please fix the permissions.");
define('_EN_INSTALL_REQ_RESPONSE_PHP_VERSION', "The minimum PHP version to install Jaws is {0}, therefore you must upgrade your PHP version.");
define('_EN_INSTALL_REQ_RESPONSE_DIRS_PERMISSION', "The directories listed below as {0} are either not readable or writable, please fix their permissions.");
define('_EN_INSTALL_REQ_RESPONSE_EXTENSION', "The {0} extension is necessary for using Jaws.");

/* Database */
define('_EN_INSTALL_DB_INFO', "You now need to setup your database, which is used to store your information to be displayed later.");
define('_EN_INSTALL_DB_NOTICE', "The database that you provide details for must already be created for this process to work.");
define('_EN_INSTALL_DB_HOST', "Hostname");
define('_EN_INSTALL_DB_HOST_INFO', "If you don't know this, it's probably safe to leave it as {0}.");//localhost
define('_EN_INSTALL_DB_DRIVER', "Driver");
define('_EN_INSTALL_DB_USER', "Username");
define('_EN_INSTALL_DB_PASS', "Password");
define('_EN_INSTALL_DB_IS_ADMIN', "Is DB Admin?");
define('_EN_INSTALL_DB_NAME', "Database Name");
define('_EN_INSTALL_DB_PATH', "Database Path");
define('_EN_INSTALL_DB_PATH_INFO', "Only fill this field out if you like change your database path in SQLite, Interbase and Firebird driver.");
define('_EN_INSTALL_DB_PORT', "Database Port");
define('_EN_INSTALL_DB_PORT_INFO', "Only fill this field out if your database is running on an another port then the default is.<br />If you have <strong>no idea</strong> what port the database is running then most likely it's running on the default port and thus we <strong>advice</strong> you to leave this field alone.");
define('_EN_INSTALL_DB_PREFIX', "Tables Prefix");
define('_EN_INSTALL_DB_PREFIX_INFO', "Some text that will be placed in front of table names, so you can run more than one Jaws site from the same database, for example <strong>blog_</strong>");
define('_EN_INSTALL_DB_RESPONSE_PATH', "The database path not exist");
define('_EN_INSTALL_DB_RESPONSE_PORT', "The port can only be a numeric value");
define('_EN_INSTALL_DB_RESPONSE_INCOMPLETE', "You must fill in all the fields apart from database path, table prefix and port.");
define('_EN_INSTALL_DB_RESPONSE_CONNECT_FAILED', "There was a problem connecting to the database, please check the details and try again.");
define('_EN_INSTALL_DB_RESPONSE_GADGET_INSTALL', "here was a problem installing core gadget {0}");
define('_EN_INSTALL_DB_RESPONSE_SETTINGS', "There was a problem while setting up the database.");

/* CreateUser */
define('_EN_INSTALL_USER_INFO', "You can now create a user account for yourself.");
define('_EN_INSTALL_USER_NOTICE', "Remember not to choose an easy to guess password since anyone who has your password has full control over your website.");
define('_EN_INSTALL_USER_USER', "Username");
define('_EN_INSTALL_USER_USER_INFO', "Your login name, which will be displayed by items you post.");
define('_EN_INSTALL_USER_PASS', "Password");
define('_EN_INSTALL_USER_REPEAT', "Repeat");
define('_EN_INSTALL_USER_REPEAT_INFO', "Repeat your password to make sure there are no typos.");
define('_EN_INSTALL_USER_NAME', "Name");
define('_EN_INSTALL_USER_NAME_INFO', "Your real name.");
define('_EN_INSTALL_USER_EMAIL', "E-Mail Address");
define('_EN_INSTALL_USER_RESPONSE_PASS_MISMATCH', "The password and repeat boxes don't match, please try again.");
define('_EN_INSTALL_USER_RESPONSE_INCOMPLETE', "You must complete the username, password, and repeat boxes.");
define('_EN_INSTALL_USER_RESPONSE_CREATE_FAILED', "There was a problem while creating your user.");

/* Settings */
define('_EN_INSTALL_SETTINGS_INFO', "You can now set the default settings for your site. You can change any of these later by logging into the Control Panel and selecting Settings.");
define('_EN_INSTALL_SETTINGS_SITE_NAME', "Site Name");
define('_EN_INSTALL_SETTINGS_SITE_NAME_INFO', "The name to display for your site.");
define('_EN_INSTALL_SETTINGS_DESCRIPTION', "Description");
define('_EN_INSTALL_SETTINGS_DESCRIPTION_INFO', "A longer description of the site.");
define('_EN_INSTALL_SETTINGS_DEFAULT_GADGET', "Default Gadget");
define('_EN_INSTALL_SETTINGS_DEFAULT_GADGET_INFO', "The gadget to display when someone visits the home page.");
define('_EN_INSTALL_SETTINGS_SITE_LANGUAGE', "Site Language");
define('_EN_INSTALL_SETTINGS_SITE_LANGUAGE_INFO', "The main language to display the site in.");
define('_EN_INSTALL_USER_RESPONSE_SITE_NAME_EMPTY', "You need to fill in the site name box.");

/* WriteConfig */
define('_EN_INSTALL_CONFIG_INFO', "You now need to save your configuration file.");
define('_EN_INSTALL_CONFIG_SOLUTION', "You can do this in two ways");
define('_EN_INSTALL_CONFIG_SOLUTION_PERMISSION', "Make <strong>{0}</strong> writable, and hit next, which will allow the installer to save the configuration itself.");
define('_EN_INSTALL_CONFIG_SOLUTION_UPLOAD', "Copy and paste the contents of the box below into a file and save it as <strong>{0}</strong>");
define('_EN_INSTALL_CONFIG_RESPONSE_WRITE_FAILED', "There was an unknown error writing the configuration file.");
define('_EN_INSTALL_CONFIG_RESPONSE_MAKE_CONFIG', "You need to either make the config directory writable, or create {0} by hand.");

/* Finished */
define('_EN_INSTALL_FINISH_INFO', "You have now finished setting up your website!");
define('_EN_INSTALL_FINISH_CHOICES', "You now have two choices, you can either <a href=\"{0}\">view your site</a> or <a href=\"{1}\">login to the control panel</a>.");
define('_EN_INSTALL_FINISH_MOVE_LOG', "Note: If you turned on the logging option at the first stage we suggest you to save it and move it / delete it");
define('_EN_INSTALL_FINISH_THANKS', "Thank you for using Jaws!");
