<?php
/**
 * JSUnixNetDeviceValidator.php - Validate if the entry is an Unix net device (eth0, eth1, eth0:0, etc)
 *
 * @version  $Id $
 * @author   Pablo Fischer <pablo@pablo.com.mx>
 *
 * <c> Pablo Fischer 2004
 * <c> Piwi
 */
require_once PIWI_PATH . '/JS/JSValidator.php';

class JSUnixNetDeviceValidator extends JSValidator
{
    /**
     * Constructor
     *
     * @access public
     * @param  string  $field  Field to validate
     * @param  string  $error  Error to print
     */
    function JSUnixNetDeviceValidator($field, $error)
    {
        parent::__construct($field, $error);

        $regexp = "/^(eth[0-9]$)|(^eth[0-9]:[1-9]$)/";
        $this->_code = "if (!form.".$this->_field.".value.match ({$regexp})) {\n";
        $this->_code.= "   alert ('".$this->_error."');\n";
        $this->_code.= "   form.".$this->_field.".focus ();\n";
        $this->_code.= "   return false;\n";
        $this->_code.= "}\n\n";
    }
}
?>