<?php
/**
 * Plugin for import gadget action
 *
 * @category   Plugin
 * @package    ActionImport
 * @author     Ali Fazelzadeh <afz@php.net>
 * @copyright  2008-2009 Jaws Development Group
 * @license    http://www.gnu.org/copyleft/gpl.html
 */
require_once JAWS_PATH . 'include/Jaws/Plugin.php';

class ActionImport extends Jaws_Plugin
{
    /**
     * Main Constructor
     *
     * @access  public
     */
    function ActionImport()
    {
        $this->_Name = 'ActionImport';
        $this->LoadTranslation();
        $this->_Description = _t('PLUGINS_IMPORT_DESCRIPTION');
        $this->_Example = '[ActionImport gadget="Blocks" action="Display" params="1"]';
        $this->_IsFriendly = false;
        $this->_Version = '0.1';
    }

    /**
     * Overrides, Parse the text
     *
     * @access  public
     * @param   string  $html Html to Parse
     * @return  string  Parsed HTML
     */
    function ParseText($html)
    {
        $blockPattern = '@\[ActionImport gadget="(.*?)" action="(.*?)" params="(.*?)"\]@ism';
        $new_html = preg_replace_callback($blockPattern, array(&$this, 'Prepare'), $html);
        return $new_html;
    }

    /**
     * The preg_replace call back function
     *
     * @access  private
     * @param   string  $matches    Matched strings from preg_replace_callback
     * @return  string  Gadget's action output or plain text on errors
     */
    function Prepare($data)
    {
        $gadget = $data[1];
        $action = $data[2];
        $params = $data[3];

        $layoutModel = $GLOBALS['app']->LoadGadget($gadget, 'LayoutHTML');
        if (!Jaws_Error::IsError($layoutModel) && method_exists($layoutModel, $action)) {
            $GLOBALS['app']->Translate->LoadTranslation($gadget, JAWS_PATH . 'gadgets');
            return $layoutModel->$action($params);
        }

        return "[ActionImport gadget=\"$gadget\" action=\"$action\" params=\"$params\"]";
    }

}